; Secure Remote Controlled Mains Switch
; Y2022 Silicon Chip

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F1459
	#include p16f1459.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_ON & _CP_OFF & _BOREN_OFF & _CLKOUTEN_OFF &_IESO_OFF & _FCMEN_OFF

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _WRT_OFF & _CPUDIV_NOCLKDIV & _USBLSCLK_24MHz & _PLLMULT_4x & _PLLEN_DISABLED & _STVREN_ON & _BORV_HI & _LPBOR_OFF & _LVP_OFF 


;..................................................................................................................................
; define;
; Bank 0 RAM (Linear address starts at 2000 for H'20')

; Math
BARGB0		equ	H'20'	; random number generator
BARGB1		equ	H'21'	; random number gen
BARGB2		equ	H'22'	; random number gen
AARGB0		equ	H'23'	; random number gen
AARGB1		equ	H'24'	; random number gen
AARGB2		equ	H'25'	; random number gen
AARGB3		equ	H'26'	; random number gen
AARGB4		equ	H'27'	; random number gen
AARGB5		equ	H'28'	; random number gen
AARGB6		equ	H'29'	; random number gen

TEMPB0		equ	H'2A'	; random gen temp files
TEMPB1		equ	H'2B'	; random gen temp files
TEMPB2		equ	H'2C'	; random gen temp files
TEMPB3		equ	H'2D'	; random gen temp files
LOOPCOUNT	equ	H'2E'	; loop counter in random gen

; Seed
RANDB0		equ	H'2F'	; random number seed ms
RANDB1		equ	H'30'	; random number seed
RANDB2		equ	H'31'	; random number seed
RANDB3		equ	H'32'	; random number seed ls
; Multiplier
MULT0		equ	H'33'	; multiplier ms
MULT1		equ	H'34'	; multiplier mid 
MULT2		equ	H'35'	; multiplier ls
; Increment
INCREMENT	equ	H'36'	; increment value
; random
RANDB4		equ	H'37'	; random number last byte
RANDB5		equ	H'38'	; random number last byte
; scramble
SCRAMBLE	equ	H'39'	; data code scramble

; Counters
CYCLE_COUNT	equ	H'3A'	; cycles per data
IDENTIFIER	equ H'3B'	; transmit identity
VALUE_1		equ	H'3C'	; delay counter
VALUE_2		equ	H'3D'	; delay counter	

MULT_CYC	equ	H'3F'	; multiplier cycle counter
VALUE		equ	H'40'	; Value of bit for sending data

; Other
TEMPX		equ	H'41'	; temporary register
MOM_PERIOD1	equ	H'42'	; period  1
COUNTER_DIV	equ	H'43'	; counter divider reducing count rate from 1024us to 262ms
FLAG		equ	H'44'	; interrupt flag
TEMP_AD		equ	H'45'	; temp value
BROWN		equ	H'46'	; brownout flag

; receive bytes
RECEIVE0	equ	H'47'	; receive byte
RECEIVE1	equ	H'48'	; receive byte
RECEIVE2	equ	H'49'	; receive byte
RECEIVE3	equ	H'4A'	; receive byte
RECEIVE4	equ	H'4B'	; receive byte
RECEIVE5	equ	H'4C'	; receive byte
RECEIVE6	equ	H'4D'	; receive byte
RECEIVE7	equ	H'4E'	; receive byte
RECEIVE8	equ	H'4F'	; receive byte
RECEIVE9	equ	H'50'	; receive byte
RECEIVE10	equ	H'51'	; receive byte

REC_EIVE0	equ	H'52'	; receive byte unscrambled
REC_EIVE1	equ	H'53'	; receive byte 		"
REC_EIVE2	equ	H'54'	; receive byte      "
REC_EIVE3	equ	H'55'	; receive byte		"
REC_EIVE4	equ	H'56'	; receive byte		"
REC_EIVE5	equ	H'57'	; receive byte unscrambled

COUNT_BITS	equ	H'58'	; bit counter for receive bytes
CNT_BIT_STO	equ	H'59'	; bit counter for receive bytes
STORE1		equ	H'5A'	; delay counter
STORE2		equ	H'5B'	; delay counter
IDENTITY	equ	H'5C'	; identity address
TIMER1H_VAL equ	H'5D'	; timer 1 preset ms byte
TIMER1L_VAL equ	H'5E'	; timer 1 preset ls byte
TIMER1H_WK	equ	H'5F'	; timer 1 working value
TIMER1L_WK	equ	H'60'	; timer 1 working value	
TIMER1H_4	equ	H'61'	; timer 1 1/4 value ms byte
TIMER1L_4	equ	H'62'	; timer 1 1/4 value ls byte
SCRAMBLE1	equ	H'63'	; data code scramble working register
STORE3		equ	H'64'	; timer counter
REPEAT		equ	H'65'	; repeat recalculation
STO_RANDB0	equ	H'66'	; stored value from previous random calculation	
STO_RANDB1	equ	H'67'	; stored value from previous random calculation	
STO_RANDB2	equ	H'68'	; stored value from previous random calculation	
STO_RANDB3	equ	H'69'	; stored value from previous random calculation	
SYNC_SET	equ	H'6A'	; flag for synchronisation 0 = first data block, 1 = second data block
TRANS_COUNT	equ H'6B'	; transient count
COUNTER		equ	H'6C'	; random value zero counter
T255		equ	H'6D'	; timer multiply flags
OUT_OF_SYNC	equ	H'6E'	; out of sync flag

; All Banks RAM
TEMP_VAL		equ	H'70'	; read data ms byte value
RANDOM_LOOP		equ	H'71'	; loop counter in random generation
R_STORE			equ	H'72'	; pseudo random generator register
READADDMS		equ	H'73'	; ms Byte of Program Address to read
READADDLS		equ	H'74'	; ls Byte of Program Address to read
COUNTER_DIV1	equ	H'75'	; counter divider1
COUNTER_DIV2	equ	H'76'	; counter divider2
COMPENSATE		equ	H'77'	; compensation value
SYNC0			equ	H'78'	; ms byte of synchronise bits (8-15)			
SYNC1			equ	H'79'	; ls byte of synchronise bits (0-7)

; working registers				
SYNCHRON_FLAG  equ H'7A'	; synchronise flag
ALL_COUNT	   equ H'7B'	; ID counter to lockout all 16 IDs					
TEMP		   equ H'7C'	; temporary
INTCON_STORE   equ H'7D'	; store intcon
LOOPS		   equ H'7E'	; write loop counter
	
; initial values
; 11 values stored for each identity with unique rolling code data. Initial data not used when synchronised
; with a transmitter

	; storage of seed 32-bit ms
	; storage of seed 32-bit
	; storage of seed 32-bit
	; storage of seed 32-bit ls

	; storage of multiplier 24-bit ms
	; storage of multiplier 24-bit
	; storage of multiplier 24-bit ls

	; storage of incrementer 
	; byte 5 of random code
	; byte 6 of random code
	; scramble data code

	org	H'1000'	;ID1 address where data is stored (32 word blocks per ID due to the 32 byte flash block erase/write)
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID1
	org	H'1020'	;ID2
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID2
	org	H'1040'	;ID3
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID3
	org	H'1060'	;ID4
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID4
	org	H'1080'	;ID5
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID5
	org	H'10A0'	;ID6
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID6
	org	H'10C0'	;ID7
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID7
	org	H'10E0'	;ID8
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID8
	org	H'1100'	;ID9
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID9
	org	H'1120'	;ID10
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID10
	org	H'1140'	;ID11
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID11
	org	H'1160'	;ID12
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID12
	org	H'1180'	;ID13
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID13
	org	H'11A0'	;ID14
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID14
	org	H'11C0'	;ID15
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID15
	org	H'11E0'	;ID16
	DA	H'3F72', H'3F2D', H'3F9B', H'3F75', H'3F00', H'3FA1', H'3F8E', H'3F1D', H'3FCD', H'3F17', H'3F00'; ID16

	; synchronisation flags ms byte
	; synchronisation flags ls byte
	; compensation value

	org	H'1220'	; synchronisation flags 1220h, 1221h, compensation value 1222h 
; initially none are synchronised of the 0-16 possible transmitter identities.
	DA	H'3F00', H'3F00', H'3F0E'

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

	org		0  				; start at address 0000h
	goto	MAIN
	org     4				; interrupt vector 0004h
INTERRUPT
	movlb	D'1'
	btfss	PIE1,TMR1IE	; if clear bypass timer 1 section
	goto	TIMER2
	movlb	D'0'
	btfss	PIR1,TMR1IF	; check timer 1 flag
	goto	TIMER2
; preload timer
	bcf		T1CON,0		; timer 1 off	
	movf	TIMER1H_VAL,w
	addwf	TMR1H,f
	movf	TIMER1L_VAL,w
	addwf	TMR1L,f
	btfsc	STATUS,C
	incf	TMR1H,f		; increase ms byte if ls addition has carry
	bsf		T1CON,0		; timer 1 on

	bcf		PIR1,TMR1IF	; clear timer 1 overflow

	bsf		FLAG,0		; set flag bit to indicate an interrupt has occurred

TIMER2
	movlb	D'0'
	btfss	PIR1,TMR2IF
	retfie
	bcf		PIR1,TMR2IF

	decf	COUNTER_DIV,f	; divider for sync set

; check T255. If clear check JP1
	movf	T255,w
	btfsc	STATUS,Z
	goto	CKJ1

	btfsc	T255,0	; when set use 255 divider
	goto	IS_X
	btfsc	T255,7
	goto	NOT_X
	
; times jumper JP1
CKJ1
	btfsc	PORTC,0
	goto	NOT_X
IS_X
	decfsz	COUNTER_DIV2,f	; extra divider /256 for momentary period when multiplier link in (JP1)
	goto	COUNTERS
NOT_X; not multiplier
	decf	COUNTER_DIV1,f	; momentary period divider

COUNTERS
	movf	COUNTER_DIV,w
	btfss	STATUS,Z		; when zero 0.26s so run counters
	goto	DIVIDER

; decrease SYNC_SET to 0 after 0.75s maximum (when 0 returns to block1 data for synchronise)

	movf	SYNC_SET,w			; block2 data 
	btfss	STATUS,Z			; if zero do not decrease
	decf	SYNC_SET,f

DIVIDER
; divider 1
	movf	COUNTER_DIV1,w		; divider for momentary period
	btfss	STATUS,Z
	retfie						; return from interrupt
BY1
	movlw	D'244'
	movwf	COUNTER_DIV			; 244 for 1.024ms x 244 = 250ms	
	movf	MOM_PERIOD1,w		; momentary period 1-255
	btfss	STATUS,Z			; if zero do not decrease
	decfsz	MOM_PERIOD1,f
	retfie						; return from interrupt

	bcf		PORTC,5				; output low on end of timeout if momentary mode
; end of interrupt 
	retfie						; return from interrupt

;,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,, 
	
MAIN

; initialise functions

; set inputs/outputs
	movlb	D'2'			; latch, bank 2
	movlw	B'00000000'	; 
	movwf	LATA
	movlw	B'00000000'	; 
	movwf	LATB
	movlw	B'00000000'	; 
	movwf	LATC

;USB
	movlb	D'29'
	bcf		UCON,3		; USB off
	bcf		UCON,1
	
; weak pullups off/on
	movlb	D'4'		; bank4	WPUA/B
	movlw	B'00110000'
	movwf	WPUA
	clrf	WPUB
	movlw	B'11110000'
	movwf	WPUB

; set I/O
	movlb	D'1'		; bank1	TRISA/B/C
	movlw   B'00111011'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'11110000'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	movlw	B'11010101'
	movwf	TRISC		; port C data direction 
; options
	movlw	B'00000111'	; weak pullups set via WPUA/B TMR0/256
	movwf	OPTION_REG	; 
; analog inputs
	movlb	D'3'		; bank3	ANSELA/B/C
	movlw	B'00000000'	; 
	movwf	ANSELA
	movlw	B'00000000' ; AN11
	movwf	ANSELB
	movlw	B'01000100'	; AN8,AN6
	movwf	ANSELC
; A/D select
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00100000'	; channel 8
; 00100000	; channel 8
; 00011000	; channel 6
	movwf	ADCON0
	movlw	B'00010000'	; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on

; oscillator	
	movlw	B'00110100'	; for 4MHz;
	movwf	OSCCON		; osc
; timer 1
	movlb	D'0'		; bank0
	movlw	H'FB'		; preload timer 1
	movwf	TIMER1H_VAL
	movwf	TMR1H
	movlw	H'FF'
	movwf	TIMER1L_VAL
	movwf	TMR1L
	clrf	T1CON
	bsf		T1CON,0		; timer 1 on

; timer2 set
	movlb	D'0'			; bank0	
	movlw	D'255'		; 
	movwf	PR2			; 
	movlw	B'00000101'	; /4 for 1024us 
	movwf	T2CON

; initial conditions

	clrf	SYNC_SET	; synchronisation set flag (used for first or second data selection)
	clrf	MOM_PERIOD1	; momentary period 1

	clrf	BROWN		; brownout flag
	clrf	SCRAMBLE
	clrf	T255		; timer multiply flags
	clrf	OUT_OF_SYNC	; out of sync flag

; read compensation value from flash
	movlw	H'12'		; ms address byte (H1222)
	movwf	READADDMS 
	movlw	H'22'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data
	movwf	COMPENSATE	; compensate value

; delay start
DELAY_START	
	call	DELAYms
	bcf		PIR1,TMR1IF	; clear timer 1 overflow
	movlw	H'FF'
	movwf	PR2			; timer 2 match

; allow interrupts
ALL_INTERRUPTS
	BANKSEL	PIE1		; bank1
	bsf	 	PIE1,TMR1IE 
	bsf		PIE1,TMR2IE
	movlb	0			; bank0
	bsf		INTCON,PEIE	; peripheral interrupt enable
	bcf		PORTC,3		; Ack. LED off
	bsf		T1CON,0		; make sure timer1 is running to count and check for overrange
 
CHECK_INPUTS

; if during brownout leave ACK LED on
	btfss	BROWN,0		; if set, brownout flag, leave ACK LED on
	bcf		PORTC,3		; ACK LED off
; Switches
	goto	BRN_OUT		; check brownout and S1

END_BRN	
	btfss	PORTA,0		; program/LEARN switch S2
	goto 	PRGM
	btfss	PORTA,1		; Clear switch S3
	goto	LOCKOUT
	goto	INPUT_SIG1

PRGM
; toggle learn LED

	btfsc	PORTC,1
	goto	L_LED_OFF
	bsf		PORTC,1		; set Learn LED on
	goto	WAIT_OFF
L_LED_OFF
	bcf		PORTC,1		; LEARN LED off
WAIT_OFF
	call	DELAY100
	btfss	PORTA,0		; program/LEARN switch S2
	goto	WAIT_OFF

; Signal input
INPUT_SIG1
	BANKSEL	PIE1		; bank1
	bsf	 	PIE1,TMR1IE 
	movlb	0			; bank0
	bsf		INTCON,GIE
	bsf		T1CON,0		; ensure timer 1 runs

	btfss	PORTC,7		; when high begin to read data
	goto	CHECK_INPUTS
	clrf	FLAG		; 1024us flag
	movlw	D'10'		; transmission counter
	movwf	TRANS_COUNT
TRANS_LOOP
	btfss	PORTC,7		; check if still high
	goto	CHECK_INPUTS; not high so out
	btfss	FLAG,0		; count flags (set in interrupt) for a 10ms high transmission from transmitter 
	goto	TRANS_LOOP
	decfsz	TRANS_COUNT,f; count
	goto	QUIETING_LOOP
	goto	SIG_IN
QUIETING_LOOP
	clrf	FLAG
	goto	TRANS_LOOP
SIG_IN
	movlw	D'56'		; 56 plus 8-bits stop/start (total 64 bits for normal transmission inc start/stop)
	btfss	PORTC,1		; if LEARN LED is on use synchronise value
	goto	IN2			; switches have operate function so bypass syncronise or learn

; if out of sync flag bit 7 set use 56 not 40
	btfss	OUT_OF_SYNC,7
	movlw	D'40'		; total of 48 bits synchronise transmission inc start stop received in two lots 
IN2
	btfss	PORTC,7		; if high then check to start reception
	goto	CHECK_INPUTS
	movwf	COUNT_BITS
	movwf	CNT_BIT_STO	; store for reference later

; use start bits to lock the transmission frequency

	movlb	D'1'		; bank 1
	bcf		PIE1,TMR1IE	; timer 1 interrupt off
	movlb	D'0'		; bank 0
	bcf		INTCON,GIE	; stop interrupt
	bcf		T1CON,0		; stop timer 1
	clrf	TMR1L		; clear timer 1
	clrf	TMR1H
	clrf	FLAG		; interrupt occurred flag
	bcf		PIR1,TMR1IF	; clear interrupt flag
	clrf	TMR0		; timer 0 cleared plus prescaler
	nop
	nop
	nop					; wait for timer0 to clear	
	bcf		INTCON,TMR0IF; clear timer 0 flag
	bsf		INTCON,GIE	
; count with timer 1 for RC7 to go low and then high, low and high corresponding to a 1,1,1 start bits

WAIT_LOW
	btfsc	INTCON,TMR0IF; timer 0 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE when timer overflow
	btfsc	PORTC,7		; wait for a low 
	goto	WAIT_LOW

WAIT_HIGH
	btfsc	INTCON,TMR0IF; timer 0 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTC,7		; wait till high 
	goto	WAIT_HIGH
	bsf		T1CON,0		; timer1 on to count and check for overrange

WAIT_LOW1
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTC,7	; wait for a low 
	goto	WAIT_LOW1

WAIT_HIGH1
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTC,7		; wait till high (start of third start bit after 15 interrupts)
	goto	WAIT_HIGH1

WAIT_LOW2
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTC,7		; wait for a low 
	goto	WAIT_LOW2

WAIT_HIGH2
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTC,7		; wait till high 
	goto	WAIT_HIGH2

; 7 interrupts
WAIT_LOW3
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTC,7		; wait for a low 
	goto	WAIT_LOW3

WAIT_HIGH3
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTC,7		; wait till high
	goto	WAIT_HIGH3

WAIT_LOW4
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTC,7		; wait for a low
	goto	WAIT_LOW4

WAIT_HIGH4
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTC,7		; wait till high
	goto	WAIT_HIGH4

WAIT_LOW5
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTC,7		; wait till low 
	goto	WAIT_LOW5

WAIT_HIGH5
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTC,7		; wait for a high 
	goto	WAIT_HIGH5

WAIT_LOW6
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTC,7		; wait till low 
	goto	WAIT_LOW6

WAIT_HIGH6
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTC,7		; wait for a high 
	goto	WAIT_HIGH6

WAIT_LOW7
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTC,7		; wait till low 
	goto	WAIT_LOW7

WAIT_HIGH7
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTC,7		; wait for a high 
	goto	WAIT_HIGH7

WAIT_LOW8
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTC,7		; wait till low 
	goto	WAIT_LOW8

WAIT_HIGH8
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTC,7		; wait for a high 
	goto	WAIT_HIGH8

WAIT_LOW9
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTC,7		; wait till low 
	goto	WAIT_LOW9

WAIT_HIGH9
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTC,7		; wait for a high 
	goto	WAIT_HIGH9


; read timer 1 and divide by 16 to get the required timer 1 offset (take from FFFF to get preload value)
; if outside range then ignore. Typically should be 1024 but 2048 to 512 allowable

	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	bcf		T1CON,0		; stop timer 1
	movf	TMR1L,w		; read timer 1
	movwf	TIMER1L_WK	; working registers
	movf	TMR1H,w
	movwf	TIMER1H_WK

; divide by 16 to get average count between each edge
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /2
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /4
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /8
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /16

; compare with over range/under range
	movf	TIMER1H_WK,w	; ms byte
	andlw	B'11111110'		; 512 and greater
	btfsc	STATUS,Z		; if zero then value too small 
	goto	CHECK_INPUTS	; IGNORE
	movf	TIMER1H_WK,w	; ms byte
	andlw	B'11111000'		; 2048 and greater
	btfss	STATUS,Z		; if not zero then value too large 
	goto	CHECK_INPUTS	; IGNORE

; take from FFFF to get preset for interrupt rate	
	movf	TIMER1H_WK,w	; ms byte
	sublw	H'FF'			; maximum
	movwf	TIMER1H_VAL
	movf	TIMER1L_WK,w	; ls byte
	sublw	H'FF'			; maximum
	movwf	TIMER1L_VAL
	btfss	STATUS,C		; if carry reduce ms byte
	decf	TIMER1H_VAL,f

; add compensation for preload losses

;	movf	COMPENSATE,w
	movlw	H'0E'
 			 
	addwf	TIMER1L_VAL,f	; add compensation
	btfsc	STATUS,C
	incf	TIMER1H_VAL,f	; if overrange increase ms byte

; preload counter 1 to sync with transmission rate 
	bcf		T1CON,0		; stop timer 1
	movf	TIMER1H_VAL,w
	movwf	TMR1H
	movf	TIMER1L_VAL,w
	movwf	TMR1L
	clrf	FLAG		; clear flag
	bcf		PIR1,TMR1IF	; clear flag
 	movlb	D'1'		; bank 1
	bsf		PIE1,TMR1IE	; enable timer1 interrupt
	movlb	D'0'		; bank 0
	bsf		T1CON,0		; timer runs

; wait for one interrupt interval
WAIT_FLG_R
	btfss	FLAG,0
	goto	WAIT_FLG_R
	clrf	FLAG

; wait for 1/4 interrupt interval to centre measurement of level on high or low transmission

; calculate 1/4 interval
	bcf		STATUS,C	; carry cleared
	rrf		TIMER1H_WK,w	; divide by 2
	movwf	TIMER1H_4	; place in secondary register
	rrf		TIMER1L_WK,w
	movwf	TIMER1L_4
	bcf		STATUS,C
	rrf		TIMER1H_4,f	; divide by 2 for total of 4
	rrf		TIMER1L_4,f

; take from FFFF to get shift in time to read data centred on a 1 or 0 value
	bcf		INTCON,GIE	; stop interrupts
	bcf		T1CON,0		; stop timer 1

	movf	TIMER1H_4,w	; ms byte
	sublw	H'FF'		; maximum
	movwf	TMR1H
	movf	TIMER1L_4,w	; ls byte
	sublw	H'FF'		; maximum
	movwf	TMR1L
	btfss	STATUS,C	; if carry reduce ms byte
	decf	TMR1H,f

	bcf		PIR1,TMR1IF	; clear interrupt flag
	bsf		T1CON,0		; run timer 1
	clrf	FLAG
	bsf		INTCON,GIE	; allow interrupts

; start of data
; shift into RECEIVE3,4,5 etc
START_DATA
	clrf	RECEIVE3
	clrf	RECEIVE4
	clrf	RECEIVE5
	clrf	RECEIVE6
	clrf	RECEIVE7
	clrf	RECEIVE8
	clrf	RECEIVE9

WAIT_FLG3
	btfss	FLAG,0		; wait for interrupt flag change
	goto	WAIT_FLG3
	clrf	FLAG		; clear flag 
	btfsc	PORTC,7		; check level
	goto	SET_CARRY
	bcf		STATUS,C	; clear carry
	bcf		PORTC,3		; ack LED
	goto	STORE_RECEIVE
SET_CARRY
	bsf		STATUS,C	; set when port is set
	bsf		PORTC,3
STORE_RECEIVE
	rlf		RECEIVE9,f
	rlf		RECEIVE8,f
	rlf		RECEIVE7,f
	rlf		RECEIVE6,f
	rlf		RECEIVE5,f
	rlf		RECEIVE4,f
	rlf		RECEIVE3,f
	decfsz	COUNT_BITS,f
	goto	WAIT_FLG3	; continue loading bits

; check stop bits
WAIT_FLG4
	btfss	FLAG,0
	goto	WAIT_FLG4
	clrf	FLAG		; clear flag
	btfss	PORTC,7		; check level must be a high (for the 1 in the stop bits)
	goto	IGNORE 
WAIT_FLG5
	bsf		PORTC,3
	btfss	FLAG,0
	goto	WAIT_FLG5
	clrf	FLAG		; clear flag 
	btfsc	PORTC,7		; check level must be a low (for the 0 in the stop bits)
	goto	IGNORE
WAIT_FLG6
	bcf		PORTC,3
	btfss	FLAG,0
	goto	WAIT_FLG6
	clrf	FLAG		; clear flag
	btfss	PORTC,7		; check level must be a high (for the 1 in the stop bits)
	goto	IGNORE 
WAIT_FLG7
	bsf		PORTC,3
	btfss	FLAG,0
	goto	WAIT_FLG7
	clrf	FLAG		; clear flag 
	btfss	PORTC,7		; check level must be a high (for the 1 in the stop bits)
	goto	IGNORE 

; when loaded check CNT_BIT_STO to see if it was for synchronisation or Data.
	movf	CNT_BIT_STO,w
	xorlw	D'56'		; data
	btfss	STATUS,Z
	goto	SYNCH_VALUES
	clrf	SYNC_SET	; reset to data block 1

; collate data for scramble recovery
	movf	RECEIVE3,w
	movwf	RECEIVE10	; identifier
; shift RECEIVE4 to 9 to RECEIVE0 to 5
	movf	RECEIVE4,w
	movwf	RECEIVE0
	movf	RECEIVE5,w
	movwf	RECEIVE1
	movf	RECEIVE6,w
	movwf	RECEIVE2
	movf	RECEIVE7,w
	movwf	RECEIVE3
	movf	RECEIVE8,w
	movwf	RECEIVE4
	movf	RECEIVE9,w
	movwf	RECEIVE5

; Identifier in RECEIVE10. Data placed in REC_EIVE,0 to 5
	
	movf	RECEIVE10,w
	andlw	B'00001111'	; select ls bytes only
	movwf	IDENTITY	; 1 of 16 transmitters

; check if this identity has been synchronised yet. If not then exit (IGNORE).
; Identity value 0 is transmitter ID0, 1 is transmitter ID1 etc 15 or F is transmitter ID15

; set location of identity values 1-8 from flash in 'synchronise'
	movlw	H'12'		; ms address byte (H1221)
	movwf	READADDMS 
	movlw	H'21'
	movwf	READADDLS	; ls address byte

	movf	IDENTITY,w	; identity value (0-15)= 1-16
	xorlw	D'00'		; if 0 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT0
	movf	IDENTITY,w
	xorlw	D'01'		; if 1 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT1
	movf	IDENTITY,w
	xorlw	D'02'		; if 2 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT2
	movf	IDENTITY,w
	xorlw	D'03'		; if 3 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT3
	movf	IDENTITY,w
	xorlw	D'04'		; if 4 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT4
	movf	IDENTITY,w
	xorlw	D'05'		; if 5 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT5
	movf	IDENTITY,w
	xorlw	D'06'		; if 6 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT6
	movf	IDENTITY,w
	xorlw	D'07'		; if 7 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT7

; set up flash address	
; set location of identity values (9-16) from flash in 'synchronise'
	movlw	H'12'		; ms address byte (H1220)
	movwf	READADDMS 
	movlw	H'20'
	movwf	READADDLS	; ls address byte

	movf	IDENTITY,w	; 0-15
	xorlw	D'08'		; if 8 check if bit 0 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT8
	movf	IDENTITY,w
	xorlw	D'09'		; if 9 check if bit 1 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT9
	movf	IDENTITY,w
	xorlw	D'10'		; if 10 check if bit 2 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT10
	movf	IDENTITY,w
	xorlw	D'11'		; if 11 check if bit 3 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT11
	movf	IDENTITY,w
	xorlw	D'12'		; if 12 check if bit 4 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT12
	movf	IDENTITY,w
	xorlw	D'13'		; if 13 check if bit 5 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT13
	movf	IDENTITY,w
	xorlw	D'14'		; if 14 check if bit 6 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT14
	movf	IDENTITY,w
	xorlw	D'15'		; if 15 check if bit 7 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	CK_IDENT15
	goto	IGNORE		; none set so ignore 

CK_IDENT0
;	check if bit 0 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,0	; 
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID1
	movlw	H'10'		; ms address byte (H100A)
	movwf	READADDMS 
	movlw	H'0A'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT1
;	check if bit 1 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,1	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID2
	movlw	H'10'		; ms address byte (H102A)
	movwf	READADDMS 
	movlw	H'2A'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT2
;	check if bit 2 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,2	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID3
	movlw	H'10'		; ms address byte (H104A)
	movwf	READADDMS 
	movlw	H'4A'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT3
;	check if bit 3 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,3	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID4
	movlw	H'10'		; ms address byte (H106A)
	movwf	READADDMS 
	movlw	H'6A'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT4
;	check if bit 4 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,4	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID5
	movlw	H'10'		; ms address byte (H108A)
	movwf	READADDMS 
	movlw	H'8A'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT5
;	check if bit 5 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,5	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID6
	movlw	H'10'		; ms address byte (H10AA)
	movwf	READADDMS 
	movlw	H'AA'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT6
;	check if bit 6 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,6	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID7
	movlw	H'10'		; ms address byte (H10CA)
	movwf	READADDMS 
	movlw	H'CA'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT7
;	check if bit 7 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,7	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID8
	movlw	H'10'		; ms address byte (H10EA)
	movwf	READADDMS 
	movlw	H'EA'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT8
;	check if bit 0 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,0	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID9
	movlw	H'11'		; ms address byte (H110A)
	movwf	READADDMS 
	movlw	H'0A'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT9
;	check if bit 1 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,1	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID10
	movlw	H'11'		; ms address byte (H112A)
	movwf	READADDMS 
	movlw	H'2A'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT10
;	check if bit 2 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,2	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID11
	movlw	H'11'		; ms address byte (H114A)
	movwf	READADDMS 
	movlw	H'4A'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT11
;	check if bit 3 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,3	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID12
	movlw	H'11'		; ms address byte (H116A)
	movwf	READADDMS 
	movlw	H'6A'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT12
;	check if bit 4 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,4	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID13
	movlw	H'11'		; ms address byte (H118A)
	movwf	READADDMS 
	movlw	H'8A'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT13
;	check if bit 5 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,5	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID14
	movlw	H'11'		; ms address byte (H11CA)
	movwf	READADDMS 
	movlw	H'AA'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT14
;	check if bit 6 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,6	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID15
	movlw	H'11'		; ms address byte (H110A)
	movwf	READADDMS 
	movlw	H'CA'
	movwf	READADDLS	; ls address byte
	goto	CON_CODE_CK	; if set can CONtinue_CODE_ChecK
CK_IDENT15
;	check if bit 7 set in flash
	call	READ			; read flash
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,7	; if set can CONtinue_CODE_ChecK
	goto	IGNORE
; set location of SCRAMBLE value in flash for ID16
	movlw	H'11'		; ms address byte (H120A)
	movwf	READADDMS 
	movlw	H'EA'
	movwf	READADDLS	; ls address byte

CON_CODE_CK; continue with code check

; get scramble value 
	call	READ			;

	movwf	SCRAMBLE

; unscramble data bytes
	bsf		PCLATH,3		; page
	call	DECODE_SCRAMBLE
	bcf		PCLATH,3

; compare for matching values
	call	MATCH
	goto	RESULT

; subroutine to compare
MATCH ; compare values received with those stored
; storage of seed 32-bit ms
; get flash location for data values. Remove the ls address bits so it starts from beginning (seed)
	movf	READADDLS,w		; ls address byte
	andlw	B'11110000'		; removes the A that points to the scramble memory location used previously
	movwf	READADDLS
	call	READ			; reads flash
	xorwf	REC_EIVE0,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
;	storage of seed 32-bit
	incf	READADDLS,f		; next flash
	call	READ			; reads flash
	xorwf	REC_EIVE1,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
;	storage of seed 32-bit
	incf	READADDLS,f		; next flash
	call	READ			; reads flash
	xorwf	REC_EIVE2,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
;	storage of seed 32-bit ls
	incf	READADDLS,f		; next flash
	call	READ			; reads flash
	xorwf	REC_EIVE3,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
;	byte 5 of random code
	movlw	D'5'
	addwf	READADDLS,f		; increase by 5 to get byte 5 of random code
	call	READ			; read flash
	xorwf	REC_EIVE4,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
;	byte 6 of random code
	incf	READADDLS,f		; next flash
	call	READ			; reads flash
	xorwf	REC_EIVE5,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; not matching
	retlw	D'01'			; matching

RESULT
	xorlw	D'01'			; if 01 then match
	btfss	STATUS,Z		; if a match skip to FUNCTIONS
;  codes do not match. Do recalculate to match operation
	goto	RECALC_TO_MATCH	; 

; *******************************************************************
FUNCTIONS
	
; Ack LED	
	bcf		PORTC,3			; acknowledge LED off
	nop
	nop
	bcf		PORTC,1

; calculate the next random data and store in Flash

	call	RECALCULATE		; next values calculated 
	call	STORE			; and stored 

; if OUT_OF_SYNC is clear run functions
; otherwise bypass acting on
	btfss	OUT_OF_SYNC,0	; if set exit any action
	goto	ACT				; Act upon code received
	clrf	OUT_OF_SYNC		; out of sync flag cleared
	bsf		OUT_OF_SYNC,7
	bsf		PORTC,1			; light LEARN LED 
	goto	CHECK_INPUTS

ACT;action
	clrf	OUT_OF_SYNC
; Data is correct then act on depending on functions required 

	btfsc	RECEIVE10,5		; if set then switch 1 
	goto	SWITCH_1_OUT	; on with timer
	btfsc	RECEIVE10,6		; if set then switch 2
	goto	SWITCH_2_OUT	; on
	btfsc	RECEIVE10,7		; if set then switch 3
	goto	SWITCH_3_OUT	; off
	goto	IGNORE			; none so ignore

SWITCH_2_OUT	; switch 2 pressed (ON)
	btfsc	BROWN,0			; if set keep relay off 
	goto	CHECK_INPUTS	; no action

; check JP2 at RA5. If open. S1 is on with timer as set by JP1. S2 is on
; if closed S2 is x255 timer
	btfsc	PORTA,5
	goto	ON2
	bsf		T255,0		; set x 255 overriding JP1
	goto	DEL_BY_CLR

ON2
	clrf	T255
	bsf		PORTC,5			; relay on
	goto	CHECK_INPUTS

SWITCH_3_OUT	; off
	clrf	T255
	bcf		PORTC,5			; relay off
	goto	CHECK_INPUTS

SWITCH_1_OUT 	; switch 1 pressed (ON with timer)
	btfss	BROWN,0			; if set keep relay off 
	goto	JP2TEST
	clrf	T255
	bcf		PORTC,5			; relay off
	goto	CHECK_INPUTS	; no action
JP2TEST
; check JP2 at RA5. If open. S1 is on with timer as set by JP1
	btfsc	PORTA,5
	goto	SET_DELAY
; if closed S1 is x1 timer
	bsf		T255,7			; set for x1 overriding JP1
	goto	DEL_BY_CLR
SET_DELAY
	clrf	T255
DEL_BY_CLR
	bsf		PORTC,5			; relay on

; get delay
; A/D conversion
; Channel 6 A/D value

	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00011000'	; channel 6
; 00011000	; channel 6
	movwf	ADCON0
	movlw	B'00010000'	; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	bcf		INTCON,GIE

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT1
	decfsz	TEMP,f
	goto	WAIT1	
	bsf		ADCON0,1		; GO/DONE bit start conversion
WAIT_CONV1
	btfsc	ADCON0,1		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV1
	movf	ADRESH,w
	btfsc	STATUS,Z		; if 0 set at 1
	movlw	D'1'
	movlb	D'0'

; place in timer
	movwf	MOM_PERIOD1
	bsf		PORTC,5			; momentary on for momentary period	
	movlw	H'FF'			; initial 0.26s	
	movwf	COUNTER_DIV1	
	bsf		INTCON,GIE
	goto	CHECK_INPUTS
	
; ************************************************************************************
; Recalculation
; if incorrect recalculate next random data 
RECALC_TO_MATCH

	movlw	D'10'			; test at repeat of 10
	movwf	REPEAT			; look ahead count
	call	RECALCULATE		; gets stored values first for random generator and then randomises values
	bsf		PCLATH,3
	call	DECODE_SCRAMBLE	; decode data from scramble
	bcf		PCLATH,3
	goto	CK_RANDBX		; 
RECALC_X
	call	RANDOM			; recalculate random number
	bsf		PCLATH,3
	call	DECODE_SCRAMBLE	; decode data from scramble
	bcf		PCLATH,3

; check next number of repeat values if not a match then abort
CK_RANDBX
	movf	RANDB0,w 
	xorwf	REC_EIVE0,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB1,w 
	xorwf	REC_EIVE1,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB2,w 
	xorwf	REC_EIVE2,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB3,w 
	xorwf	REC_EIVE3,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB4,w 
	xorwf	REC_EIVE4,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB5,w 
	xorwf	REC_EIVE5,w		; check ms byte
	btfss	STATUS,Z		; when the same all above match	
	goto	NXT1			; not a match

; when a match, act on functions
	bcf		PORTC,1			; learn LED off if it was on
	call	STORE			; 
	goto	FUNCTIONS		; a match so act upon

NXT1
	decfsz	REPEAT,f		; decrease until 0 
	goto	RECALC_X
	
	btfsc	OUT_OF_SYNC,0	; if set 
	goto	STILL_OUT

; recalculate 200 times to find a match. If found, set OUT_OF_SYNC,0 flag

	movlw	D'200'
	movwf	REPEAT			; look ahead count
	bsf		OUT_OF_SYNC,0
	goto	RECALC_X

STILL_OUT
	bcf		PORTC,1			; LEARN LED off
	clrf	OUT_OF_SYNC
	goto	IGNORE			; no match after 200 future codes 

RECALCULATE

; get values (RANDB0,1,2,3, multiplier and increment) for calculation

; RANDB0
; get flash location for data values. Return to beginning of data
	movf	READADDLS,w		; ls address byte
	andlw	B'11110000'		; removes the ls bits
	movwf	READADDLS
	call	READ			; reads flash
	movwf	RANDB0
; RANDB1
	incf	READADDLS,f		; next flash
	call	READ			; reads flash
	movwf	RANDB1
; RANDB2
	incf	READADDLS,f		; next flash
	call	READ			; reads flash
	movwf	RANDB2
; RAND3
	incf	READADDLS,f		; next flash
	call	READ			; reads flash
	movwf	RANDB3
; MULT0
	incf	READADDLS,f		; next flash
	call	READ			; reads flash
	movwf	MULT0
; MULT1
	incf	READADDLS,f		; next flash
	call	READ			; reads flash
	movwf	MULT1
; MULT2
	incf	READADDLS,f		; next flash
	call	READ			; reads flash
	movwf	MULT2
; INCREMENT
	incf	READADDLS,f		; next flash
	call	READ			; reads flash
	movwf	INCREMENT
; scramble
	incf	READADDLS,f		; next flash
	incf	READADDLS,f		; next flash
	incf	READADDLS,f		; next flash, scramble value
	call	READ
	movwf	SCRAMBLE

	call	RANDOM			; recalculate the random values
	return

STORE

; store into flash memory from RAM (RANDB0-RANDB5, MULT0-3, Increment and Scramble). Stores in the correct ID location
; READADDMS and READADDLS are already set up for ID and ls bits set to 0 in LS byte in WRITE
; start of RAM
	movlw	H'20'
	movwf	FSR0H
	movlw 	H'0F'
	movwf	FSR0L
	call	WRITE		; write values
	return


; ********************************************************************
; SYNCHRONISE/REGISTER

; if synchronise, load into flash
SYNCH_VALUES

; First data block IDENTIFIER (RECEIVE5), RANDB0,1,2,3 (40 bits) (RECEIVE6,7,8&9)
; Second data block MULT0,1,2, INCREMENT, SCRAMBLE (40 bits)located in RECEIVE5 to RECEIVE9
; identifier provides starting address 
; also set synchronisation flag in flash for the identity

; Check which block
	movf	SYNC_SET,w		; if zero data block 1
	btfss	STATUS,Z
	goto	BLOCK2

; bits 0,1,2,3 are the identity bits set at 0 to 15 with IDENTITY bits 0,1,2,3

	movf	RECEIVE5,w
	andlw	B'00001111'		; ls bits only
	movwf	IDENTITY	
; from identity we get flash address range 

; transfer RECEIVE6,7,8,9 values to RANDB0,1,2,3	

; RAND0
	movf	RECEIVE6,w		; Random ms byte
	movwf	RANDB0	
; RAND1
	movf	RECEIVE7,w		; Random ms byte
	movwf	RANDB1
; RAND2
	movf	RECEIVE8,w		; Random ms byte
	movwf	RANDB2
; RAND3
	movf	RECEIVE9,w		; Random ms byte
	movwf	RANDB3

	movlw	D'03'
	movwf	SYNC_SET		; set at 3 so can be reduced to 0 after 0.75secs max
	call	DELAYms
	goto	SIG_IN			; CHECK_INPUTS

; block 2
BLOCK2

; transfer RECEIVE5,6,7,8,9 to MULT0,1,2, INCREMENT, SCRAMBLE 
	movf	RECEIVE5,w
	movwf	MULT0
	movf	RECEIVE6,w
	movwf	MULT1
	movf	RECEIVE7,w
	movwf	MULT2
	movf	RECEIVE8,w
	movwf	INCREMENT
	movf	RECEIVE9,w
	movwf	SCRAMBLE
	
; based on Identity, get memory locations to store in flash

	movf	IDENTITY,w	; identity value (0-15)= 1-16
	xorlw	D'00'		; if 0 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT0
	movf	IDENTITY,w
	xorlw	D'01'		; if 1 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT1
	movf	IDENTITY,w
	xorlw	D'02'		; if 2 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT2
	movf	IDENTITY,w
	xorlw	D'03'		; if 3 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT3
	movf	IDENTITY,w
	xorlw	D'04'		; if 4 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT4
	movf	IDENTITY,w
	xorlw	D'05'		; if 5 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT5
	movf	IDENTITY,w
	xorlw	D'06'		; if 6 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT6
	movf	IDENTITY,w
	xorlw	D'07'		; if 7 check if bit is set in least significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT7

; set location of identity values (9-16) in flash 
	movf	IDENTITY,w	; 0-15
	xorlw	D'08'		; if 8 check if bit 0 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT8
	movf	IDENTITY,w
	xorlw	D'09'		; if 9 check if bit 1 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT9
	movf	IDENTITY,w
	xorlw	D'10'		; if 10 check if bit 2 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT10
	movf	IDENTITY,w
	xorlw	D'11'		; if 11 check if bit 3 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT11
	movf	IDENTITY,w
	xorlw	D'12'		; if 12 check if bit 4 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT12
	movf	IDENTITY,w
	xorlw	D'13'		; if 13 check if bit 5 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT13
	movf	IDENTITY,w
	xorlw	D'14'		; if 14 check if bit 6 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT14
	movf	IDENTITY,w
	xorlw	D'15'		; if 15 check if bit 7 set in most significant byte of synchronise flash
	btfsc	STATUS,Z
	goto	IDENT15
	goto	IGNORE		; none set so ignore 

IDENT0
; set location of values in flash for ID1
	movlw	H'10'		; ms address byte (H1000)
	movwf	READADDMS 
	movlw	H'00'
	movwf	READADDLS	; ls address byte
	goto	NEXT		; 
IDENT1
; set location of values in flash for ID2
	movlw	H'10'		; ms address byte (H1020)
	movwf	READADDMS 
	movlw	H'20'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT2
; set location of values in flash for ID3
	movlw	H'10'		; ms address byte (H1040)
	movwf	READADDMS 
	movlw	H'40'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT3
; set location of values in flash for ID4
	movlw	H'10'		; ms address byte (H1060)
	movwf	READADDMS 
	movlw	H'60'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT4
; set location of values in flash for ID5
	movlw	H'10'		; ms address byte (H1080)
	movwf	READADDMS 
	movlw	H'80'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT5
; set location of values in flash for ID6
	movlw	H'10'		; ms address byte (H10A0)
	movwf	READADDMS 
	movlw	H'A0'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT6
; set location of values in flash for ID7
	movlw	H'10'		; ms address byte (H10C0)
	movwf	READADDMS 
	movlw	H'C0'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT7
; set location of values in flash for ID8
	movlw	H'10'		; ms address byte (H10E0)
	movwf	READADDMS 
	movlw	H'E0'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT8
; set location of values in flash for ID9
	movlw	H'11'		; ms address byte (H1100)
	movwf	READADDMS 
	movlw	H'00'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT9
; set location of values in flash for ID10
	movlw	H'11'		; ms address byte (H1120)
	movwf	READADDMS 
	movlw	H'20'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT10
; set location of values in flash for ID11
	movlw	H'11'		; ms address byte (H1140)
	movwf	READADDMS 
	movlw	H'40'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT11
; set location of values in flash for ID12
	movlw	H'11'		; ms address byte (H1160)
	movwf	READADDMS 
	movlw	H'60'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT12
; set location of values in flash for ID13
	movlw	H'11'		; ms address byte (H1180)
	movwf	READADDMS 
	movlw	H'80'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT13
; set location of values in flash for ID14
	movlw	H'11'		; ms address byte (H11C0)
	movwf	READADDMS 
	movlw	H'A0'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT14
; set location of values in flash for ID15
	movlw	H'11'		; ms address byte (H1100)
	movwf	READADDMS 
	movlw	H'C0'
	movwf	READADDLS	; ls address byte
	goto	NEXT
IDENT15
; set location of values in flash for ID16
	movlw	H'11'		; ms address byte (H1200)
	movwf	READADDMS 
	movlw	H'E0'
	movwf	READADDLS	; ls address byte

NEXT
; then store  (FSR set at 200F)

	call	STORE
; then expand out identity to individual bits (ID0 set bit 0 etc) and store these 
; first read and store in RAM

; read ms byte of synchronise value from flash
	movlw	H'12'		; ms address byte 
	movwf	READADDMS 
	movlw	H'20'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data
	movwf	BARGB0		; synchronise value 8-15
; read ls byte of synchronise value from flash
	movlw	H'12'		; ms address byte 
	movwf	READADDMS 
	movlw	H'21'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data
	movwf	BARGB1		; synchronise value 0-7
; read compensation value from flash
	movlw	H'12'		; ms address byte 
	movwf	READADDMS 
	movlw	H'22'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data
	movwf	BARGB2		; compensate value
	
	clrf	SYNC_SET	; first block flag cleared

;  store identifier 0 to 7 

	clrf	SYNCHRON_FLAG	; cleared ready to set a bit
	movf	IDENTITY,w
	btfsc	STATUS,Z		; when 0 set bit 0 
	bsf		SYNCHRON_FLAG,0
	movf	IDENTITY,w
	xorlw	D'01'			; when 1 set bit 
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,1	
	movf	IDENTITY,w
	xorlw	D'02'			; when 2 set bit 
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,2	
	movf	IDENTITY,w
	xorlw	D'03'			; when 3 set bit 3 
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,3	
	movf	IDENTITY,w
	xorlw	D'04'			; when 4 set bit 4
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,4	
	movf	IDENTITY,w
	xorlw	D'05'			; when 5 set bit 5 
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,5	
	movf	IDENTITY,w
	xorlw	D'06'			; when 6 set bit 6 
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,6	
	movf	IDENTITY,w
	xorlw	D'07'			; when 7 set bit 7 
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,7	

; OR the two values SYNCHRON_FLAG and BARGB1
	movf	SYNCHRON_FLAG,w
	iorwf	BARGB1,f		; add in any extra IDs when synchronised	

; identifier 8 to 16 
ID8_16
	clrf	SYNCHRON_FLAG	; cleared ready to set a bit
	movf	IDENTITY,w
	xorlw	D'08'			; when 8 set bit 0 
	btfsc	STATUS,Z		; 
	bsf		SYNCHRON_FLAG,0
	movf	IDENTITY,w
	xorlw	D'09'			; when 9 set bit 1 
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,1	
	movf	IDENTITY,w
	xorlw	D'10'			; when 10 set bit 2 
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,2	
	movf	IDENTITY,w
	xorlw	D'11'			; when 11 set bit 3
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,3	
	movf	IDENTITY,w
	xorlw	D'12'			; when 12 set bit 4 
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,4	
	movf	IDENTITY,w
	xorlw	D'13'			; when 13 set bit 5
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,5	
	movf	IDENTITY,w
	xorlw	D'14'			; when 14 set bit 6
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,6	
	movf	IDENTITY,w
	xorlw	D'15'			; when 15 set bit 7 
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,7	
; OR the two values SYNCHRON_FLAG and BARGB1
	movf	SYNCHRON_FLAG,w
	iorwf	BARGB0,f		; add in any extra IDs when synchronised

; write values
	movlw	H'12'		; ms address byte 
	movwf	READADDMS 
	movlw	H'20'
	movwf	READADDLS	; ls address byte

; start of RAM
	movlw	H'20'
	movwf	FSR0H
	movlw 	H'00'
	movwf	FSR0L
	call	WRITE		; write values

; flash ACK LED
FLAS_ACK
	bcf		PORTC,3			; acknowledge LED off
	movlw 	D'5'
	movwf	STORE3
	
MORE_DELAY1
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAY1	
; show ACK LED
	bsf		PORTC,3			; acknowledge LED on
	movlw 	D'5'
	movwf	STORE3
	
MORE_DELAY2
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAY2	
; flash ACK LED
	bcf		PORTC,3			; acknowledge LED off
	movlw 	D'5'
	movwf	STORE3
	
MORE_DELAY3
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAY3	
; show ACK LED
	bsf		PORTC,3			; acknowledge LED on
	btfss	PORTA,0			; keep flashing until synch switch open
	goto	FLAS_ACK
	bcf		PORTC,1			; synch LED off
	bcf		PORTC,3			; ACK LED off
	goto	CHECK_INPUTS

; *********************************************************************

IGNORE
; start and stop bits incorrect so ignore data. Flash Ack LED to indicate ignore 
	
	bcf		PORTC,3		; ack LED off 
	goto	CHECK_INPUTS


; ********************************************************************

LOCKOUT
 ; load timeout counter for all ID lockout 

	call	DELAY
	movlw	D'10'
	movwf	ALL_COUNT
LENGTH	; switch must be pressed for 1s or more
	btfsc	PORTA,1			; check lockout if open start normal program
	goto	CHECK_INPUTS	; not pressed long enough
	call	DELAY
	decfsz	ALL_COUNT,f
	goto	LENGTH


	bsf		PORTC,3			; ACK LED
	movf	INTCON,w
	movwf	INTCON_STORE	; store GIE (bit7)
	bcf		INTCON,GIE 		; Disable interrupts 
	
; identity bits set at 0 to 15 with IDENTITY bits 0,1,2,3 on BCD switch
	movf	PORTB,w
	movwf	TEMP
; correct order for identity
	clrf	IDENTITY		; set at 0 initially 1 of 16 transmitters
	btfss	TEMP,6			; BCD1, (8) if  low then ms bit (8) so set bit 3 
	bsf		IDENTITY,3
	btfss	TEMP,5			; BCD1, (2)
	bsf		IDENTITY,1
	btfss	TEMP,4			; BCD1, (4)
	bsf		IDENTITY,2
	btfss	TEMP,7			; BCD1, (1)
	bsf		IDENTITY,0

;  clear identifier 0 to 7 

	movlw	H'FF'			; all 1's
	movwf	SYNCHRON_FLAG	; set ready to clear a bit
	movf	IDENTITY,w
	btfsc	STATUS,Z		; when 0 clear bit 0 
	bcf		SYNCHRON_FLAG,0

	movf	IDENTITY,w
	xorlw	D'01'			; when 1 clear bit 1
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,1	
	movf	IDENTITY,w
	xorlw	D'02'			; when 2 clear bit 2 
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,2	
	movf	IDENTITY,w
	xorlw	D'03'			; when 3 clear bit 3 
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,3	
	movf	IDENTITY,w
	xorlw	D'04'			; when 4 clear bit 4 
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,4	
	movf	IDENTITY,w
	xorlw	D'05'			; when 5 clear bit 5
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,5	
	movf	IDENTITY,w
	xorlw	D'06'			; when 6 clear bit 6
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,6	
	movf	IDENTITY,w
	xorlw	D'07'			; when 7 clear bit 7
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,7	

; get current flags
; read flash at 1221h
	movlw	H'12'		; ms address byte 
	movwf	READADDMS 
	movlw	H'21'
	movwf	READADDLS	; ls address byte
	call	READ

	andwf	SYNCHRON_FLAG,w	; exclude new flag
	movwf	BARGB1			; ready to write values

;  clear identifier 8 to 16 
	movlw	H'FF'
	movwf	SYNCHRON_FLAG	; cleared ready to set a bit
	movf	IDENTITY,w
	xorlw	D'08'			; when 8 clear bit 0  
	btfsc	STATUS,Z		; 
	bcf		SYNCHRON_FLAG,0
	movf	IDENTITY,w
	xorlw	D'09'			; when 9 clear bit 1
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,1	
	movf	IDENTITY,w
	xorlw	D'10'			; when 10 clear bit 2
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,2	
	movf	IDENTITY,w
	xorlw	D'11'			; when 11 clear bit 3 
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,3	
	movf	IDENTITY,w
	xorlw	D'12'			; when 12 clear bit 4
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,4	
	movf	IDENTITY,w
	xorlw	D'13'			; when 13 clear bit 5 
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,5	
	movf	IDENTITY,w
	xorlw	D'14'			; when 14 clear bit 6 
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,6	
	movf	IDENTITY,w
	xorlw	D'15'			; when 15 clear bit 7 
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,7	

; get current flags
; read flash at 1220h
	movlw	H'12'		; ms address byte 
	movwf	READADDMS 
	movlw	H'20'
	movwf	READADDLS	; ls address byte
	call	READ
	andwf	SYNCHRON_FLAG,w	; exclude new flag
	movwf	BARGB0			; ready to write values

; read compensation
	movlw	H'12'		; ms address byte 
	movwf	READADDMS 
	movlw	H'22'
	movwf	READADDLS	; ls address byte
	call	READ
	movwf	BARGB2		; ready to write values

; start of RAM
	movlw	H'20'
	movwf	FSR0H
	movlw 	H'00'
	movwf	FSR0L
	movlw	H'20'
	movwf	READADDLS
	call	WRITE		; write values
OPEN_LOOP
	btfsc	PORTA,1			; check lockout if open start normal program
	goto	LOCKOUT_OPEN
	call	DELAY
	goto	OPEN_LOOP
	
LOCKOUT_OPEN	
	bcf		PORTC,3			; Ack LED off

	btfsc	INTCON_STORE,7	; store GIE (bit7)
	bsf		INTCON,GIE		; interrupt on
	goto	CHECK_INPUTS

;.................................................................................
; Brownout

; run A/D for brown out. Off below 200VAC on again at 220VAC
; mains voltage measure for brownout detection
BRN_OUT

; A/D conversion
; Channel 8 A/D value

	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00100000'	; channel 8
; 00100000	; channel 8
	movwf	ADCON0;

	movlw	B'00010000'	; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	bcf		INTCON,GIE

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT3
	decfsz	TEMP,f
	goto	WAIT3	
	bsf		ADCON0,1		; GO/DONE bit start conversion
WAIT_CONV3
	btfsc	ADCON0,1		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV3
	movf	ADRESH,w
	movlb	D'0'
	bsf		INTCON,GIE
	movwf	TEMP
; check for over 220VAC under 200VAC
	sublw	D'136'		; if over 220VAC switch brownout flag off
	btfss	STATUS,C
	goto	BROWN_OFF
	movf	TEMP,w
	sublw	D'98'		; if under 98 (192VAC) switch brownout flag on
	btfss	STATUS,C
	goto	BROWN_BY 	; no change
; brownout
; for brownout set flag BROWN,0
	bsf		BROWN,0		; set brownout flag
	bcf		PORTC,5		; relay off on brownout
	nop
	nop
	bsf		PORTC,3		; ACK LED on
	goto	BROWN_BY

BROWN_OFF
	bcf		BROWN,0
	bcf		PORTC,3		; Ack LED off
	
BROWN_BY

; check external switch S1
	btfsc	PORTC,4		; switch input if low closed
	goto	END_BRN	

; switch closed
; if relay on, switch off
	btfsc	PORTC,5		; if high relay is on
	goto	OFF_SW

; switch relay on either as on or on with timer
	clrf	T255		; clear JP2 action
; JP3 low, ON/OFF
; JP3 high ON with timer/OFF
	btfss	PORTA,4		; JP3
	goto	ON_SW	

; timer
; if brownout (BROWN,0) is set do not switch on relay
	btfss	BROWN,0
	bsf		PORTC,5			; relay on

; get delay. VR1 sets 260ms to 66.5s from 1 to 255 in MON_PERIOD
; the times (X) jumper JP1 sets another x 255 for 66.5s to 4.7 hours
; A/D conversion
; Channel 6 A/D value

	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00011000'	; channel 6
; 00100000	; channel 8
; 00011000	; channel 6
	movwf	ADCON0
	movlw	B'00010000'	; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	bcf		INTCON,GIE

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT2
	decfsz	TEMP,f
	goto	WAIT2	
	bsf		ADCON0,1		; GO/DONE bit start conversion
WAIT_CONV2
	btfsc	ADCON0,1		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV2
	movf	ADRESH,w
	movlb	D'0'			; bank 0

; place A/D value in timer
	btfsc	STATUS,Z		; if zero set at 1
	movlw	D'1'
	movwf	MOM_PERIOD1
	movlw	H'FF'			; initial 0.26s	
	movwf	COUNTER_DIV1
	movwf	COUNTER_DIV2	
	bsf		INTCON,GIE

ON_SW
	btfss	BROWN,0		; relay stays off with brownout
	bsf		PORTC,5		; relay on
	goto	WAIT_OPEN1	
OFF_SW
	bcf		PORTC,5		; relay off

WAIT_OPEN1
	call	DELAYms
	btfss	PORTC,4		; wait until high (S1 open)
	goto	WAIT_OPEN1	; switch closed so wait until open
	call	DELAYms
	btfss	PORTC,4		; wait until high (S1 open)
	goto	WAIT_OPEN1	; switch closed so wait until open
	goto	END_BRN		; switch open so continue with program


; **************************************************************

; subroutines

; delay
DELAYms
DELAY
DELAY100 ; ~100ms
	movlw	D'100'         ; set delay period 
	movwf	VALUE_2		; 
LP_1:
	movlw	D'250'     	; set delay period value 1 
	movwf	VALUE_1		; VALUE_2 = w
LP_2:
    nop
    decfsz	VALUE_1,f
	goto	LP_2
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_1
	return
; ************************************************


RANDOM

; Random number generator

;	Input:	32 bit initial integer seed in AARGB0, AARGB1, AARGB2, AARGB3

;	Linear congruential random number generator

;	X  <- (a * X(previous) + c) |mod m|

;	X is the result (2**48 bits used) and becomes the seed for next calculation 
;	with multiplier a (24 bit), increment c (8-bit) and
;	modulus m (number of bits of result selected for seed (2**31)-1 

		movf		RANDB0,w		; random numbers
		movwf		AARGB0			; 2**32
        movwf		STO_RANDB0
		movf		RANDB1,w
		movwf		AARGB1
        movwf		STO_RANDB1
		movf		RANDB2,w
		movwf		AARGB2
        movwf		STO_RANDB2
		movf		RANDB3,w
		movwf		STO_RANDB3
		movwf		AARGB3
					
; decrease by 1
		movf		AARGB3,w
		btfsc		STATUS,Z	; if zero decrease next byte
		decf		AARGB2,f
		decf		AARGB3,f

		movf		AARGB2,w
		btfsc		STATUS,Z	; if zero decrease next byte
		decf		AARGB1,f
		decf		AARGB2,f
	
		movf		AARGB1,w
		btfsc		STATUS,Z	; if zero decrease next byte
		decf		AARGB0,f
		decf		AARGB1,f	; modulus 2**32-1	
		bcf			AARGB0,7	; 2**31-1

; increment		
		movf		INCREMENT,w		; increment value
        addwf       AARGB6,F		; c = incrementer
        btfsc       STATUS,Z		; carry to more significant bytes
        incf        AARGB5,F
		btfsc		STATUS,Z
		incf		AARGB4,F
		btfsc		STATUS,Z
		incf		AARGB3,F
		btfsc       STATUS,Z
        incf        AARGB2,F
		btfsc		STATUS,Z
		incf		AARGB1,F
		btfsc		STATUS,Z
		incf		AARGB0,F

; ENTER_MULTipliers
		movf		MULT2,w			; multiplier 
		movwf		BARGB2
		movf		MULT1,w
		movwf		BARGB1
		movf		MULT0,w
		movwf		BARGB0

		call		FXM3224U		; multiply
; transfer values to RAND registers
	
		movf		AARGB5,w
		movwf		RANDB5
		movf		AARGB4,w
		movwf		RANDB4

		movf		AARGB0,w
		movwf		RANDB0
		movf		AARGB1,W
		movwf		RANDB1
		movf		AARGB2,W
		movwf		RANDB2
		movf		AARGB3,W
		movwf		RANDB3
        
 ; if equal to last time (almost never probability), alter values
		
		movf		RANDB0,w
        xorwf       STO_RANDB0,w    
		btfss		STATUS,Z
        goto        RYX
 		movf		RANDB1,w
        xorwf       STO_RANDB1,w    
		btfss		STATUS,Z
        goto        RYX
        movf		RANDB2,w
        xorwf       STO_RANDB2,w    
		btfss		STATUS,Z
        goto        RYX
        movf		RANDB3,w
        xorwf       STO_RANDB3,w    
		btfss		STATUS,Z
        goto        RYX
; all the same value as befor, so make alterations
        movf        MULT0,w
        addwf       RANDB0,f
        movf        MULT1,w
        addwf       RANDB1,f
        movf        MULT2,w
        addwf       RANDB2,f
RYX
    
; generate further random output with pseudo random sequence generator (31bit)
;(note: Using bit labelling 1-31 (rather than 0 to 30 of traditional binary counts)
; RANDB0,1,2&3 used as the seed    

        movf        SCRAMBLE,w      ; data scramble value (0-255)
        movwf       RANDOM_LOOP
        bsf         STATUS,C        ; set carry 
RL 
; Return Loop
        rlf         RANDB0,w		; move Q31 to ms bit 
        movwf       R_STORE			; store value for xoring with Q28
; get Q28
        swapf       RANDB0,w		; Q28 to ms bit
; both store and w have required Q31 and Q28 in ms bit
        xorwf       R_STORE,f		; xor Q31 and Q28
        rlf         R_STORE,w       ; move xored value to carry
; move shift register values along 1
        rlf         RANDB3,f		; carry to ls byte	
        rlf         RANDB2,f		; carry to next byte
        rlf         RANDB1,f		; carry to next byte
        rlf         RANDB0,f		; carry to ms byte
        decfsz      RANDOM_LOOP,f   ; loop at scramble value length
        goto        RL              ; return loop
        incf		SCRAMBLE,f      ; increase scramble value each time
        return

;....................................................................
; read data memory
READ; 'w' has read data
	movf	INTCON,w		; store GIE setting bit 7
	movwf	INTCON_STORE
	bcf		INTCON,GIE 	; Disable interrupts
	movlb	D'3'		;  bank 3 
	movf	READADDMS,w 
	movwf 	PMADRH		; ms Byte of Program Address to read
	movf	READADDLS,w
	movwf 	PMADRL 		; ls Byte of Program Address to read
	bcf		PMCON1,CFGS	; avoid configuration space
	bsf	 	PMCON1,RD 	; Read
	nop 					
	nop
; memory is read in second cycle PM read instruction
	movf	PMDATH,w 	; ms Byte of Program data 
	movwf	TEMP_VAL
	movf	PMDATL,w 	; ls Byte of Program data in 'w'
	movlb	D'0'		; bank 0
	btfsc	INTCON_STORE,7	; if set then set GIE
	bsf		INTCON,GIE		; re-enable interrupts 
	return
;.............................................

; write to data memory
WRITE
	clrf	LOOPS			; counter
	movf	INTCON,w
	movwf	INTCON_STORE	; store GIE (bit7)
	bcf		INTCON,GIE 	; Disable interrupts so required sequences will execute properly
; load write latches
	movlb	 D'03'				; bank 3
	movf	 READADDMS,W		; Load upper 6 bits of  address boundary			
	movwf	 PMADRH ;
	movf	 READADDLS,W 		; Load lower 8 bits of erase address boundary
	andlw	 B'11110000'		; clear ls bits to start of ID memory
	movwf	 PMADRL ;

; erase first
	bcf		 PMCON1,CFGS ; Not configuration space
	bsf		 PMCON1,FREE ; Specify an erase operation
	bsf		 PMCON1,WREN ; Enable writes
	movlw	 H'55'			; Start of required write sequence:
	movwf	 PMCON2 		; Write 55h
	movlw	 H'AA' ;
	movwf	 PMCON2 		; Write AAh
	bsf		 PMCON1,WR 	; Set WR bit to begin erase
	nop					 	; NOP instructions are forced as processor writes all the program memory write latches simultaneously to program memory.
	nop	 
	bcf		 PMCON1,WREN ; Disable writes

; load latches
	movf	 READADDMS,W		; Load upper 6 bits of  address boundary			
	movwf	 PMADRH ;
	movf	 READADDLS,W 		; Load lower 8 bits of erase address boundary
	andlw	 B'11110000'		; clear ls bits to start of ID memory
	movwf	 PMADRL ;

	bcf		PMCON1,CFGS	; Not configuration space
	bsf		PMCON1,WREN	 ; Enable writes
	bsf		PMCON1,LWLO 	; Only Load Write Latches

LOOPW
	moviw	FSR0++ 			; Load first data byte into lower
	movwf	PMDATL ;
	movlw	H'3F'	 		; Load second data byte into upper
	movwf	PMDATH ;

	movf	LOOPS,w		 ; Check  lower bits of address
	xorlw	0x0F			 ; Check if we're on the last of 32 addresses
;	andlw	0x1F ;
	btfsc	STATUS,Z 		; Exit if last of 32 words,
	goto	START_WRITE ;

	movlw	 H'55'		 	; Start of required write sequence:
	movwf	 PMCON2 		; Write 55h
	movlw	 H'AA' ;
	movwf	 PMCON2			; Write AAh
	bsf		 PMCON1,WR 		; Set WR bit to begin write
	nop					 	; nop instructions are forced as processor loads program memory write latches
	nop ;
	incf	 PMADRL,f	 	; Still loading latches Increment address
	incf	 LOOPS,f
	goto	 LOOPW

START_WRITE ; write
	bcf		PMCON1,LWLO	; No more loading latches - Start Flash program
; memory write
	movlw	H'55'			; Start of required write sequence:
	movwf	PMCON2 			; Write 55h
	movlw	H'AA' ;
	movwf	PMCON2 			; Write AAh
	bsf		PMCON1,WR 		; Set WR bit to begin write
	nop						; NOP instructions are forced as processor writes all the program memory write latches simultaneously to program memory.
	nop	  
	bcf		PMCON1,WREN 	; Disable writes
	movlb	 D'0'

	btfsc	INTCON_STORE,7	; if set then set GIE
	bsf		INTCON,GIE		; re-enable interrupts 
	return

;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


;       32x24 Bit Unsigned Fixed Point Multiply 32x24 -> 56

;       Input:  32 bit unsigned fixed point multiplicand in AARGB0, AARGB1,
;               AARGB2, AARGB3

;               24 bit unsigned fixed point multiplier in BARGB0, BARGB1,
;               BARGB2

;       Use:    CALL    FXM3224U

;       Output: 56 bit unsigned fixed point product in AARGB0

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     11+617+2 = 630 clocks

;       Min Timing:     11+151 = 162 clocks

;       PM: 11+139+1 = 151              DM: 15

FXM3224U
               	clrf   		 	AARGB4          ; clear partial product
               	clrf    		AARGB5
               	clrf    		AARGB6
                movf   			AARGB0,W
                movwf   		TEMPB0
                movf   			AARGB1,W
                movwf   		TEMPB1
                movf   			AARGB2,W
                movwf   		TEMPB2
                movf   			AARGB3,W
                movwf   		TEMPB3

               	call 			UMUL3224L

                retlw           D'00'

; UMUL3224L        macro

;       Max Timing:     2+15+6*25+24+2+7*26+25+2+7*27+26 = 617 clks

;       Min Timing:     2+7*6+5+1+7*6+5+1+7*6+5+6 = 151 clks

;       PM: 31+24+2+25+2+26+2+27 = 139            DM: 15

UMUL3224L       movlw   		D'8'
                movwf   		LOOPCOUNT

LOOPUM3224A
                rrf    		 	BARGB2,F
                btfsc   		STATUS,C
               	goto   			ALUM3224NAP
                decfsz  		LOOPCOUNT,F
               	goto   			LOOPUM3224A

                movwf   		LOOPCOUNT

LOOPUM3224B
                rrf     		BARGB1,F
                btfsc   		STATUS,C
               	goto   			BLUM3224NAP
                decfsz  		LOOPCOUNT,F
               	goto   			LOOPUM3224B

                movwf  			LOOPCOUNT

LOOPUM3224C
                rrf     		BARGB0,F
                btfsc   		STATUS,C
              	goto  	 		CLUM3224NAP
                decfsz  		LOOPCOUNT,F
               	goto  	 		LOOPUM3224C

              	clrf    		AARGB0
               	clrf    		AARGB1
               	clrf    		AARGB2
               	clrf    		AARGB3
                retlw   		D'00'
                
ALUM3224NAP     bcf     		STATUS,C
               	goto  	 		ALUM3224NA
                
BLUM3224NAP     bcf     		STATUS,C
               	goto 	  		BLUM3224NA
                
CLUM3224NAP     bcf     		STATUS,C
              	goto  	 		CLUM3224NA

ALOOPUM3224
                rrf     		BARGB2,F
                btfss   		STATUS,C
                goto   			ALUM3224NA
                movf    		TEMPB3,W
                addwf   		AARGB3,F
                movf            TEMPB2,W
                btfsc           STATUS,C
                incfsz          TEMPB2,W
                addwf           AARGB2,F
                movf            TEMPB1,W
                btfsc           STATUS,C
                incfsz          TEMPB1,W
                addwf           AARGB1,F
                movf            TEMPB0,W
                btfsc           STATUS,C
                incfsz          TEMPB0,W
                addwf           AARGB0,F

ALUM3224NA
                rrf    			AARGB0,F
                rrf    			AARGB1,F
                rrf    			AARGB2,F
                rrf             AARGB3,F
                rrf             AARGB4,F
                decfsz  		LOOPCOUNT,F
                goto    		ALOOPUM3224

                movlw   		D'8'
                movwf   		LOOPCOUNT

BLOOPUM3224
                rrf     		BARGB1,F
                btfss   		STATUS,C
              	goto  	 		BLUM3224NA
                movf    		TEMPB3,W
                addwf   		AARGB3,F
                movf            TEMPB2,W
                btfsc           STATUS,C
                incfsz          TEMPB2,W
                addwf           AARGB2,F
                movf            TEMPB1,W
                btfsc           STATUS,C
                incfsz          TEMPB1,W
                addwf           AARGB1,F
                movf            TEMPB0,W
                btfsc           STATUS,C
                incfsz          TEMPB0,W
                addwf           AARGB0,F

BLUM3224NA
                rrf    			AARGB0,F
                rrf    			AARGB1,F
                rrf    			AARGB2,F
                rrf             AARGB3,F
                rrf             AARGB4,F
                rrf             AARGB5,F
                decfsz  		LOOPCOUNT,F
              	goto   			BLOOPUM3224

                movlw   		D'8'
                movwf   		LOOPCOUNT

CLOOPUM3224
                rrf     		BARGB0,F
                btfss   		STATUS,C
               	goto 	  		CLUM3224NA
                movf    		TEMPB3,W
                addwf   		AARGB3,F
                movf            TEMPB2,W
                btfsc           STATUS,C
                incfsz          TEMPB2,W
                addwf           AARGB2,F
                movf            TEMPB1,W
                btfsc           STATUS,C
                incfsz          TEMPB1,W
                addwf           AARGB1,F
                movf            TEMPB0,W
                btfsc           STATUS,C
                incfsz          TEMPB0,W
                addwf           AARGB0,F

CLUM3224NA
                rrf  			AARGB0,F
                rrf    			AARGB1,F
                rrf    			AARGB2,F
                rrf    			AARGB3,F
                rrf             AARGB4,F
                rrf             AARGB5,F
                rrf             AARGB6,F
                decfsz  		LOOPCOUNT,F
                goto   			CLOOPUM3224
				return	

; ******************************************************************************************************

	org H'0900' ;  (pclath,3 set)
; scramble data decode
DECODE_SCRAMBLE
	movf	SCRAMBLE,w
	andlw	B'00011111'	; count of 32 maximum
	movwf	SCRAMBLE1
	btfsc	STATUS,Z	; if zero
	goto	ZERO_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 1	
	goto	ONE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 2	
	goto	TWO_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 3	
	goto	THREE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 4	
	goto	FOUR_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 5	
	goto	FIVE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 6	
	goto	SIX_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 7	
	goto	SEVEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 8	
	goto	EIGHT_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 9	
	goto	NINE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 10	
	goto	TEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 11	
	goto	ELEVEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 12	
	goto	TWELVE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 13	
	goto	THIRTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 14	
	goto	FOURTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 15	
	goto	FIVETEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 16	
	goto	SIXTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 17	
	goto	SEVENTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 18
	goto	EIGHTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 19	
	goto	NINETEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 20	
	goto	TWENTY_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 21	
	goto	TWENTYONE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 22	
	goto	TWENTYTWO_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 23	
	goto	TWENTYTHREE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 24	
	goto	TWENTYFOUR_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 25	
	goto	TWENTYFIVE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 26	
	goto	TWENTYSIX_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 27	
	goto	TWENTYSEVEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 28	
	goto	TWENTYEIGHT_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 29	
	goto	TWENTYNINE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 30	
	goto	THIRTY_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 31	
	goto	THIRTYONE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 32	
	goto	THIRTYTWO_SCRAMBLE

ZERO_SCRAMBLE
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
ONE_SCRAMBLE
; 0,1,3,2,4,5 transmitter scramble (swap 2&3)
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE3	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE2	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWO_SCRAMBLE
; 0,2,1,3,4,5 (swap 2&1)
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
THREE_SCRAMBLE
; 0,2,3,1,4,5 scramble
; 0,1,2,3,4,5 unscramble
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
FOUR_SCRAMBLE
; 0,3,1,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
FIVE_SCRAMBLE
; 0,3,2,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
SIX_SCRAMBLE
; 1,2,3,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
SEVEN_SCRAMBLE
; 1,2,0,3,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
EIGHT_SCRAMBLE
; 1,3,0,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
NINE_SCRAMBLE
; 1,3,2,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TEN_SCRAMBLE
; 1,0,2,3,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
ELEVEN_SCRAMBLE
; 1,0,3,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWELVE_SCRAMBLE
; 2,0,1,3,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
THIRTEEN_SCRAMBLE
; 2,0,3,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
FOURTEEN_SCRAMBLE
; 2,1,0,3,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
FIVETEEN_SCRAMBLE
; 2,1,3,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
SIXTEEN_SCRAMBLE
; 2,3,0,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE0	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE1	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
SEVENTEEN_SCRAMBLE
; 2,3,1,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE1	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE0	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
EIGHTEEN_SCRAMBLE
; 3,0,1,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE1	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE2	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
NINETEEN_SCRAMBLE
; 3,0,2,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE2	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE1	; 
	movf	RECEIVE4,w
 	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWENTY_SCRAMBLE
; 3,1,0,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE0	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE2	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWENTYONE_SCRAMBLE
; 3,1,2,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWENTYTWO_SCRAMBLE
; 3,2,0,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWENTYTHREE_SCRAMBLE
; 3,2,1,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWENTYFOUR_SCRAMBLE
; 4,5,0,1,2,3
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE2
	movf	RECEIVE5,w
	movwf	REC_EIVE3
	return
TWENTYFIVE_SCRAMBLE
; 4,5,0,1,3,2
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE3
	movf	RECEIVE5,w
	movwf	REC_EIVE2
	return
TWENTYSIX_SCRAMBLE
; 4,5,0,2,1,3
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE1
	movf	RECEIVE5,w
	movwf	REC_EIVE3
	return
TWENTYSEVEN_SCRAMBLE
; 4,5,0,2,3,1
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE3
	movf	RECEIVE5,w
	movwf	REC_EIVE1
	return
TWENTYEIGHT_SCRAMBLE
; 4,5,0,3,1,2
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE1
	movf	RECEIVE5,w
	movwf	REC_EIVE2
	return
TWENTYNINE_SCRAMBLE
; 4,5,0,3,2,1
; 0,1,2,3,4,5	
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE2
	movf	RECEIVE5,w
	movwf	REC_EIVE1
	return
THIRTY_SCRAMBLE
; 4,5,1,2,3,0
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE3
	movf	RECEIVE5,w
	movwf	REC_EIVE0
	return
THIRTYONE_SCRAMBLE
; 4,5,1,2,0,3	
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE0
	movf	RECEIVE5,w
	movwf	REC_EIVE3
	return
THIRTYTWO_SCRAMBLE
; 4,5,1,3,0,2	
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE0
	movf	RECEIVE5,w
	movwf	REC_EIVE2
	return



 end